/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.component;

import com.spinyowl.legui.component.Button;
import com.spinyowl.legui.component.misc.listener.togglebutton.ToggleButtonMouseClickListener;
import com.spinyowl.legui.event.MouseClickEvent;
import com.spinyowl.legui.icon.Icon;
import com.spinyowl.legui.style.color.ColorConstants;
import com.spinyowl.legui.theme.Themes;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.joml.Vector2f;
import org.joml.Vector4f;

public class ToggleButton
extends Button {
    private Icon togglededBackgroundIcon;
    private boolean toggled;
    private Vector4f toggledBackgroundColor;

    public ToggleButton(String text, float x, float y, float width, float height) {
        super(text, x, y, width, height);
        this.initialize();
    }

    public ToggleButton() {
        this.initialize();
    }

    public ToggleButton(String text) {
        super(text);
        this.initialize();
    }

    public ToggleButton(float x, float y, float width, float height) {
        super(x, y, width, height);
        this.initialize();
    }

    public ToggleButton(Vector2f position, Vector2f size) {
        super(position, size);
        this.initialize();
    }

    private void initialize() {
        this.getStyle().getBackground().setColor(ColorConstants.red());
        this.toggledBackgroundColor = ColorConstants.green();
        ToggleButtonMouseClickListener toggleButtonClickListener = new ToggleButtonMouseClickListener();
        this.getListenerMap().addListener(MouseClickEvent.class, toggleButtonClickListener);
        Themes.getDefaultTheme().getThemeManager().getComponentTheme(ToggleButton.class).applyAll(this);
    }

    public boolean isToggled() {
        return this.toggled;
    }

    public void setToggled(boolean toggled) {
        this.toggled = toggled;
    }

    public Vector4f getToggledBackgroundColor() {
        return this.toggledBackgroundColor;
    }

    public void setToggledBackgroundColor(Vector4f toggledBackgroundColor) {
        this.toggledBackgroundColor = toggledBackgroundColor;
    }

    public Icon getTogglededBackgroundIcon() {
        return this.togglededBackgroundIcon;
    }

    public void setTogglededBackgroundIcon(Icon togglededBackgroundIcon) {
        this.togglededBackgroundIcon = togglededBackgroundIcon;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ToggleButton button = (ToggleButton)o;
        return new EqualsBuilder().appendSuper(super.equals(o)).append((Object)this.toggledBackgroundColor, (Object)button.toggledBackgroundColor).append(this.toggled, button.toggled).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append((Object)this.toggledBackgroundColor).append(this.toggled).toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("toggledBackgroundColor", (Object)this.toggledBackgroundColor).append("toggled", this.toggled).toString();
    }
}

