/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.component;

import com.spinyowl.legui.animation.Animation;
import com.spinyowl.legui.component.Component;
import com.spinyowl.legui.component.Panel;
import com.spinyowl.legui.component.ScrollBar;
import com.spinyowl.legui.component.TextAreaField;
import com.spinyowl.legui.component.TextComponent;
import com.spinyowl.legui.component.Viewport;
import com.spinyowl.legui.component.event.textarea.TextAreaFieldUpdateEvent;
import com.spinyowl.legui.component.misc.animation.textarea.TextAreaScrollAnimation;
import com.spinyowl.legui.component.misc.listener.textarea.TextAreaFieldUpdateListener;
import com.spinyowl.legui.component.misc.listener.textarea.TextAreaViewportScrollListener;
import com.spinyowl.legui.component.optional.Orientation;
import com.spinyowl.legui.component.optional.TextState;
import com.spinyowl.legui.event.ScrollEvent;
import com.spinyowl.legui.style.Style;
import com.spinyowl.legui.style.color.ColorConstants;
import com.spinyowl.legui.style.length.Length;
import com.spinyowl.legui.style.length.LengthType;
import com.spinyowl.legui.style.util.StyleUtilities;
import com.spinyowl.legui.theme.Themes;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector4f;

public class TextArea
extends Component
implements TextComponent,
Viewport {
    private static final float INITIAL_SCROLL_SIZE = 8.0f;
    private ScrollBar verticalScrollBar;
    private ScrollBar horizontalScrollBar;
    private Component viewport;
    private TextAreaField textAreaField;
    private Animation animation;

    public TextArea() {
        this.initialize();
    }

    public TextArea(float x, float y, float width, float height) {
        super(x, y, width, height);
        this.initialize();
    }

    public TextArea(Vector2f position, Vector2f size) {
        super(position, size);
        this.initialize();
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public void setAnimation(Animation animation) {
        if (this.animation != null) {
            this.animation.stopAnimation();
        }
        this.animation = animation;
        if (animation != null) {
            this.animation.startAnimation();
        }
    }

    private void initialize() {
        this.getStyle().setDisplay(Style.DisplayType.FLEX);
        float viewportWidth = this.getSize().x - 8.0f;
        float viewportHeight = this.getSize().y - 8.0f;
        this.viewport = new TextAreaViewport(0.0f, 0.0f, viewportWidth, viewportHeight);
        this.viewport.getStyle().getBackground().setColor(1.0f, 1.0f, 1.0f, 0.0f);
        this.viewport.getStyle().setBorder(null);
        this.viewport.getStyle().setTop(0.0f);
        this.viewport.getStyle().setLeft(0.0f);
        this.viewport.getStyle().setBottom(8.0f);
        this.viewport.getStyle().setRight(8.0f);
        this.viewport.setTabFocusable(false);
        this.textAreaField = new TextAreaField(0.0f, 0.0f, viewportWidth, viewportHeight);
        this.textAreaField.getStyle().setBorder(null);
        this.textAreaField.setTabFocusable(false);
        this.viewport.add(this.textAreaField);
        this.add(this.viewport);
        this.getStyle().getBackground().setColor(ColorConstants.transparent());
        this.animation = new TextAreaScrollAnimation(this);
        this.animation.startAnimation();
        this.verticalScrollBar = new ScrollBar();
        this.verticalScrollBar.getStyle().setWidth(8.0f);
        this.verticalScrollBar.getStyle().setTop(0.0f);
        this.verticalScrollBar.getStyle().setRight(0.0f);
        this.verticalScrollBar.getStyle().setBottom(8.0f);
        this.verticalScrollBar.setOrientation(Orientation.VERTICAL);
        this.verticalScrollBar.setViewport(this);
        this.verticalScrollBar.setTabFocusable(false);
        this.horizontalScrollBar = new ScrollBar();
        this.horizontalScrollBar.getStyle().setHeight(8.0f);
        this.horizontalScrollBar.getStyle().setLeft(0.0f);
        this.horizontalScrollBar.getStyle().setRight(8.0f);
        this.horizontalScrollBar.getStyle().setBottom(0.0f);
        this.horizontalScrollBar.setOrientation(Orientation.HORIZONTAL);
        this.horizontalScrollBar.setViewport(this);
        this.horizontalScrollBar.setTabFocusable(false);
        this.add(this.verticalScrollBar);
        this.add(this.horizontalScrollBar);
        this.viewport.getListenerMap().addListener(ScrollEvent.class, new TextAreaViewportScrollListener());
        this.textAreaField.getListenerMap().addListener(TextAreaFieldUpdateEvent.class, new TextAreaFieldUpdateListener(this));
        Themes.getDefaultTheme().getThemeManager().getComponentTheme(TextArea.class).applyAll(this);
    }

    public ScrollBar getVerticalScrollBar() {
        return this.verticalScrollBar;
    }

    public void setVerticalScrollBar(ScrollBar verticalScrollBar) {
        this.verticalScrollBar.setViewport(null);
        this.remove(this.verticalScrollBar);
        this.verticalScrollBar = verticalScrollBar;
        this.add(verticalScrollBar);
        this.verticalScrollBar.setViewport(this);
    }

    public ScrollBar getHorizontalScrollBar() {
        return this.horizontalScrollBar;
    }

    public void setHorizontalScrollBar(ScrollBar horizontalScrollBar) {
        this.horizontalScrollBar.setViewport(null);
        this.remove(this.horizontalScrollBar);
        this.horizontalScrollBar = horizontalScrollBar;
        this.add(horizontalScrollBar);
        this.horizontalScrollBar.setViewport(this);
    }

    public void setHorizontalScrollBarVisible(boolean enabled) {
        if (enabled) {
            Length<Float> height = this.horizontalScrollBar.getStyle().getHeight();
            if (height == null) {
                height = LengthType.pixel(this.horizontalScrollBar.getSize().y);
                this.horizontalScrollBar.getStyle().setHeight(height);
            }
            this.viewport.getStyle().setBottom(height);
            this.verticalScrollBar.getStyle().setBottom(height);
        } else {
            this.viewport.getStyle().setBottom(0.0f);
            this.verticalScrollBar.getStyle().setBottom(0.0f);
        }
        this.horizontalScrollBar.getStyle().setDisplay(enabled ? Style.DisplayType.MANUAL : Style.DisplayType.NONE);
    }

    public void setVerticalScrollBarVisible(boolean enabled) {
        if (enabled) {
            Length<Float> width = this.verticalScrollBar.getStyle().getWidth();
            if (width == null) {
                width = LengthType.pixel(this.verticalScrollBar.getSize().x);
                this.verticalScrollBar.getStyle().setWidth(width);
            }
            this.viewport.getStyle().setRight(width);
            this.horizontalScrollBar.getStyle().setRight(width);
        } else {
            this.viewport.getStyle().setRight(0.0f);
            this.horizontalScrollBar.getStyle().setRight(0.0f);
        }
        this.verticalScrollBar.getStyle().setDisplay(enabled ? Style.DisplayType.MANUAL : Style.DisplayType.NONE);
    }

    public void setHorizontalScrollBarHeight(float height) {
        this.horizontalScrollBar.getStyle().setHeight(height);
        this.viewport.getStyle().setBottom(height);
        this.verticalScrollBar.getStyle().setBottom(height);
    }

    public void setVerticalScrollBarWidth(float width) {
        this.verticalScrollBar.getStyle().setWidth(width);
        this.viewport.getStyle().setRight(width);
        this.horizontalScrollBar.getStyle().setRight(width);
    }

    public TextAreaField getTextAreaField() {
        return this.textAreaField;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TextArea)) {
            return false;
        }
        TextArea panel = (TextArea)o;
        return new EqualsBuilder().appendSuper(super.equals(o)).append((Object)this.verticalScrollBar, (Object)panel.verticalScrollBar).append((Object)this.horizontalScrollBar, (Object)panel.horizontalScrollBar).append((Object)this.textAreaField, (Object)panel.textAreaField).isEquals();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("verticalScrollBar", (Object)this.verticalScrollBar).append("horizontalScrollBar", (Object)this.horizontalScrollBar).append("viewport", (Object)this.viewport).append("textAreaField", (Object)this.textAreaField).toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append((Object)this.verticalScrollBar).append((Object)this.horizontalScrollBar).append((Object)this.viewport).append((Object)this.textAreaField).toHashCode();
    }

    public Component getViewport() {
        return this.viewport;
    }

    @Override
    public Vector2f getViewportSize() {
        return new Vector2f((Vector2fc)this.viewport.getSize());
    }

    @Override
    public Vector2f getViewportViewSize() {
        return new Vector2f((Vector2fc)this.textAreaField.getSize());
    }

    @Override
    public TextState getTextState() {
        return this.textAreaField.getTextState();
    }

    @Override
    public void setTextState(TextState textState) {
        this.textAreaField.setTextState(textState);
    }

    public int getCaretPosition() {
        return this.textAreaField.getCaretPosition();
    }

    public void setCaretPosition(int caretPosition) {
        this.textAreaField.setCaretPosition(caretPosition);
    }

    public boolean isEditable() {
        return this.textAreaField.isEditable();
    }

    public void setEditable(boolean editable) {
        this.textAreaField.setEditable(editable);
    }

    public int getMouseCaretPosition() {
        return this.textAreaField.getMouseCaretPosition();
    }

    public void setMouseCaretPosition(int mouseCaretPosition) {
        this.textAreaField.setMouseCaretPosition(mouseCaretPosition);
    }

    public int getStartSelectionIndex() {
        return this.textAreaField.getStartSelectionIndex();
    }

    public void setStartSelectionIndex(int startSelectionIndex) {
        this.textAreaField.setStartSelectionIndex(startSelectionIndex);
    }

    public int getEndSelectionIndex() {
        return this.textAreaField.getEndSelectionIndex();
    }

    public void setEndSelectionIndex(int endSelectionIndex) {
        this.textAreaField.setEndSelectionIndex(endSelectionIndex);
    }

    public String getSelection() {
        return this.textAreaField.getSelection();
    }

    public int getTabSize() {
        return this.textAreaField.getTabSize();
    }

    public void setTabSize(int tabSize) {
        this.textAreaField.setTabSize(tabSize);
    }

    public void resizeTextAreaField() {
        Vector2f viewportSize = this.getViewportSize();
        Vector4f padding = StyleUtilities.getPadding(this.textAreaField, this.textAreaField.getStyle());
        float maxTextWidth = Math.max(this.textAreaField.getMaxTextWidth() + padding.x + padding.z, viewportSize.x);
        float maxTextHeight = Math.max(this.textAreaField.getMaxTextHeight() + padding.y + padding.w, viewportSize.y);
        this.textAreaField.setSize(maxTextWidth, maxTextHeight);
    }

    public class TextAreaViewport
    extends Panel {
        public TextAreaViewport() {
        }

        public TextAreaViewport(float x, float y, float width, float height) {
            super(x, y, width, height);
        }

        public TextAreaViewport(Vector2f position, Vector2f size) {
            super(position, size);
        }

        @Override
        public void setSize(float width, float height) {
            super.setSize(width, height);
        }

        @Override
        public void setSize(Vector2f size) {
            super.setSize(size);
            TextArea.this.resizeTextAreaField();
        }
    }
}

