/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.component;

import com.spinyowl.legui.component.Button;
import com.spinyowl.legui.component.Component;
import com.spinyowl.legui.component.Panel;
import com.spinyowl.legui.component.misc.listener.splitpanel.SplitPanelDragListener;
import com.spinyowl.legui.component.misc.listener.splitpanel.SplitPanelSeparatorClickListener;
import com.spinyowl.legui.component.misc.listener.splitpanel.SplitPanelSeparatorCursorEnterListener;
import com.spinyowl.legui.component.misc.listener.splitpanel.SplitPanelSeparatorListenerDelegate;
import com.spinyowl.legui.component.optional.Orientation;
import com.spinyowl.legui.component.optional.align.HorizontalAlign;
import com.spinyowl.legui.component.optional.align.VerticalAlign;
import com.spinyowl.legui.event.CursorEnterEvent;
import com.spinyowl.legui.event.MouseClickEvent;
import com.spinyowl.legui.event.MouseDragEvent;
import com.spinyowl.legui.style.Style;
import com.spinyowl.legui.style.color.ColorConstants;
import com.spinyowl.legui.style.flex.FlexStyle;
import com.spinyowl.legui.style.font.TextDirection;
import com.spinyowl.legui.theme.Themes;
import java.util.Objects;
import org.joml.Vector2f;

public class SplitPanel
extends Panel {
    private Orientation orientation;
    private Component topLeft;
    private Component bottomRight;
    private SeparatorButton separator;
    private float ratio = 50.0f;
    private float separatorThickness = 4.0f;

    public SplitPanel(Orientation orientation) {
        this.orientation = Objects.requireNonNull(orientation);
        this.initialize();
    }

    private void initialize() {
        this.separator = new SeparatorButton();
        this.topLeft = new Panel();
        this.bottomRight = new Panel();
        this.separator.getTextState().setText("");
        this.add(this.topLeft);
        this.add(this.separator);
        this.add(this.bottomRight);
        SplitPanelSeparatorListenerDelegate delegate = new SplitPanelSeparatorListenerDelegate(this);
        this.separator.getListenerMap().addListener(MouseClickEvent.class, new SplitPanelSeparatorClickListener(delegate));
        this.separator.getListenerMap().addListener(CursorEnterEvent.class, new SplitPanelSeparatorCursorEnterListener(delegate));
        this.separator.getListenerMap().addListener(MouseDragEvent.class, new SplitPanelDragListener(this));
        this.separator.setTextDirection(this.orientation != Orientation.HORIZONTAL ? TextDirection.HORIZONTAL : TextDirection.VERTICAL_TOP_DOWN);
        this.separator.getStyle().setHorizontalAlign(HorizontalAlign.CENTER);
        this.separator.getStyle().setVerticalAlign(VerticalAlign.MIDDLE);
        this.separator.setTabFocusable(false);
        this.separator.getStyle().setBorderRadius(0.0f);
        this.topLeft.getStyle().setBorderRadius(0.0f);
        this.topLeft.setTabFocusable(false);
        this.bottomRight.getStyle().setBorderRadius(0.0f);
        this.bottomRight.setTabFocusable(false);
        this.resetStyle();
        Themes.getDefaultTheme().applyAll(this);
        this.topLeft.getStyle().getBackground().setColor(ColorConstants.lightGreen());
        this.bottomRight.getStyle().getBackground().setColor(ColorConstants.lightBlue());
    }

    private void updateGrow() {
        this.topLeft.getStyle().getFlexStyle().setFlexGrow(this.getLeftGrow());
        this.bottomRight.getStyle().getFlexStyle().setFlexGrow(this.getRightGrow());
    }

    @Override
    public void setSize(Vector2f size) {
        super.setSize(size);
        this.resetStyle();
    }

    @Override
    public void setSize(float width, float height) {
        super.setSize(width, height);
        this.resetStyle();
    }

    private int getLeftGrow() {
        return (int)(this.ratio * this.getActualSpace() / 100.0f);
    }

    private int getRightGrow() {
        return (int)((100.0f - this.ratio) * this.getActualSpace() / 100.0f);
    }

    private float getActualSpace() {
        float actual = Orientation.HORIZONTAL == this.orientation ? this.getSize().x - this.separatorThickness : this.getSize().y - this.separatorThickness;
        return actual;
    }

    public void resetStyle() {
        this.getStyle().setDisplay(Style.DisplayType.FLEX);
        if (this.orientation == Orientation.VERTICAL) {
            this.getStyle().getFlexStyle().setFlexDirection(FlexStyle.FlexDirection.COLUMN);
            this.separator.getStyle().setMaxHeight(this.separatorThickness);
            this.separator.getStyle().setMinHeight(this.separatorThickness);
            this.separator.getStyle().setMaxWidth(null);
            this.separator.getStyle().setMinWidth(null);
        } else {
            this.getStyle().getFlexStyle().setFlexDirection(FlexStyle.FlexDirection.ROW);
            this.separator.getStyle().setMaxHeight(null);
            this.separator.getStyle().setMinHeight(null);
            this.separator.getStyle().setMaxWidth(this.separatorThickness);
            this.separator.getStyle().setMinWidth(this.separatorThickness);
        }
        this.resetSeparator();
        this.resetTopLeft();
        this.resetBottomRight();
    }

    private void resetSeparator() {
        this.separator.getStyle().setPosition(Style.PositionType.RELATIVE);
        this.separator.getStyle().getFlexStyle().setFlexGrow(1);
        this.separator.getStyle().getFlexStyle().setFlexShrink(1);
    }

    private void resetBottomRight() {
        this.bottomRight.getStyle().setPosition(Style.PositionType.RELATIVE);
        this.bottomRight.getStyle().getFlexStyle().setFlexGrow(this.getRightGrow());
        this.bottomRight.getStyle().getFlexStyle().setFlexShrink(1);
    }

    private void resetTopLeft() {
        this.topLeft.getStyle().setPosition(Style.PositionType.RELATIVE);
        this.topLeft.getStyle().getFlexStyle().setFlexGrow(this.getLeftGrow());
        this.topLeft.getStyle().getFlexStyle().setFlexShrink(1);
    }

    public float getSeparatorThickness() {
        return this.separatorThickness;
    }

    public void setSeparatorThickness(float separatorThickness) {
        if (separatorThickness <= 0.0f) {
            return;
        }
        this.separatorThickness = separatorThickness;
        if (Orientation.HORIZONTAL == this.orientation) {
            this.separator.getStyle().setMaxWidth(separatorThickness);
            this.separator.getStyle().setMinWidth(separatorThickness);
        } else {
            this.separator.getStyle().setMaxHeight(separatorThickness);
            this.separator.getStyle().setMinHeight(separatorThickness);
        }
    }

    public Component getTopLeft() {
        return this.topLeft;
    }

    public void setTopLeft(Component topLeft) {
        if (topLeft != null) {
            this.remove(this.topLeft);
            this.topLeft = topLeft;
            this.add(0, topLeft);
            this.resetTopLeft();
        }
    }

    public Component getBottomRight() {
        return this.bottomRight;
    }

    public void setBottomRight(Component bottomRight) {
        if (bottomRight != null) {
            this.remove(this.bottomRight);
            this.bottomRight = bottomRight;
            this.add(bottomRight);
            this.resetBottomRight();
        }
    }

    public float getRatio() {
        return this.ratio;
    }

    public void setRatio(float ratio) {
        if (ratio < 0.0f) {
            ratio = 0.0f;
        } else if (ratio > 100.0f) {
            ratio = 100.0f;
        }
        this.ratio = ratio;
        this.updateGrow();
    }

    public Button getSeparator() {
        return this.separator;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        if (orientation == null) {
            return;
        }
        this.orientation = orientation;
        this.resetStyle();
    }

    private static class SeparatorButton
    extends Button {
        private SeparatorButton() {
        }
    }
}

