/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.component;

import com.spinyowl.legui.animation.Animation;
import com.spinyowl.legui.component.Component;
import com.spinyowl.legui.component.Panel;
import com.spinyowl.legui.component.ScrollBar;
import com.spinyowl.legui.component.Viewport;
import com.spinyowl.legui.component.misc.animation.scrollablepanel.ScrollablePanelAnimation;
import com.spinyowl.legui.component.misc.listener.scrollablepanel.ScrollablePanelViewportScrollListener;
import com.spinyowl.legui.component.optional.Orientation;
import com.spinyowl.legui.event.AddChildEvent;
import com.spinyowl.legui.event.RemoveChildEvent;
import com.spinyowl.legui.event.ScrollEvent;
import com.spinyowl.legui.style.Style;
import com.spinyowl.legui.style.color.ColorConstants;
import com.spinyowl.legui.style.length.Length;
import com.spinyowl.legui.style.length.LengthType;
import com.spinyowl.legui.theme.Themes;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.joml.Vector2f;
import org.joml.Vector2fc;

public class ScrollablePanel
extends Component
implements Viewport {
    private static final float INITIAL_SCROLL_SIZE = 8.0f;
    private ScrollBar verticalScrollBar;
    private ScrollBar horizontalScrollBar;
    private Component viewport;
    private Component container;
    private Animation animation;
    private boolean autoResize = false;

    public ScrollablePanel() {
        this.initialize();
    }

    public ScrollablePanel(float x, float y, float width, float height) {
        super(x, y, width, height);
        this.initialize();
    }

    public ScrollablePanel(Vector2f position, Vector2f size) {
        super(position, size);
        this.initialize();
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public void setAnimation(Animation animation) {
        if (this.animation != null) {
            this.animation.stopAnimation();
        }
        this.animation = animation;
        if (animation != null) {
            this.animation.startAnimation();
        }
    }

    private void initialize() {
        this.container = new ScrollablePanelContainer();
        this.container.setTabFocusable(false);
        this.container.getListenerMap().addListener(AddChildEvent.class, e -> this.calculateSize());
        this.container.getListenerMap().addListener(RemoveChildEvent.class, e -> this.calculateSize());
        this.viewport = new ScrollablePanelViewport();
        this.viewport.add(this.container);
        this.viewport.getListenerMap().addListener(ScrollEvent.class, new ScrollablePanelViewportScrollListener());
        this.viewport.setTabFocusable(false);
        this.add(this.viewport);
        this.autoResize = true;
        this.autoResize = false;
        this.verticalScrollBar = new ScrollBar();
        this.horizontalScrollBar = new ScrollBar();
        this.add(this.verticalScrollBar);
        this.add(this.horizontalScrollBar);
        this.verticalScrollBar.setViewport(this);
        this.verticalScrollBar.setOrientation(Orientation.VERTICAL);
        this.verticalScrollBar.setTabFocusable(false);
        this.horizontalScrollBar.setViewport(this);
        this.horizontalScrollBar.setOrientation(Orientation.HORIZONTAL);
        this.horizontalScrollBar.setTabFocusable(false);
        this.applyStyles();
        this.calculateSize();
        this.animation = new ScrollablePanelAnimation(this);
        this.animation.startAnimation();
        Themes.getDefaultTheme().getThemeManager().getComponentTheme(ScrollablePanel.class).applyAll(this);
    }

    private void calculateSize() {
        if (this.autoResize) {
            Vector2f viewportSize = this.calculateViewportSize();
            for (Component childComponent : this.container.getChildComponents()) {
                float right = childComponent.getPosition().x + childComponent.getSize().x;
                float bottom = childComponent.getPosition().y + childComponent.getSize().y;
                if (right > viewportSize.x) {
                    viewportSize.x = right;
                }
                if (!(bottom > viewportSize.y)) continue;
                viewportSize.y = bottom;
            }
            this.container.setSize(viewportSize);
        }
    }

    private void applyStyles() {
        this.getStyle().setDisplay(Style.DisplayType.FLEX);
        this.setVStyles();
        this.setHStyles();
        this.setViewportStyles();
        this.container.getStyle().setBorder(null);
        this.getStyle().getBackground().setColor(ColorConstants.transparent());
    }

    private void setVStyles() {
        this.verticalScrollBar.getStyle().setWidth(8.0f);
        this.verticalScrollBar.getStyle().setTop(0.0f);
        this.verticalScrollBar.getStyle().setRight(0.0f);
        this.verticalScrollBar.getStyle().setBottom(8.0f);
    }

    private void setHStyles() {
        this.horizontalScrollBar.getStyle().setHeight(8.0f);
        this.horizontalScrollBar.getStyle().setLeft(0.0f);
        this.horizontalScrollBar.getStyle().setRight(8.0f);
        this.horizontalScrollBar.getStyle().setBottom(0.0f);
    }

    private void setViewportStyles() {
        this.viewport.getStyle().getBackground().setColor(1.0f, 1.0f, 1.0f, 0.0f);
        this.viewport.getStyle().setBorder(null);
        this.viewport.getStyle().setTop(0.0f);
        this.viewport.getStyle().setLeft(0.0f);
        this.viewport.getStyle().setBottom(8.0f);
        this.viewport.getStyle().setRight(8.0f);
    }

    private Vector2f calculateViewportSize() {
        Vector2f size = this.getSize();
        float viewportWidth = size.x - (this.isVerticalScrollBarVisible() ? this.verticalScrollBar.getSize().x : 0.0f);
        float viewportHeight = size.y - (this.isHorizontalScrollBarVisible() ? this.horizontalScrollBar.getSize().y : 0.0f);
        return new Vector2f(viewportWidth, viewportHeight);
    }

    @Override
    public void setSize(float width, float height) {
        super.setSize(width, height);
        this.calculateSize();
    }

    @Override
    public void setSize(Vector2f size) {
        super.setSize(size);
        this.calculateSize();
    }

    public ScrollBar getVerticalScrollBar() {
        return this.verticalScrollBar;
    }

    public void setVerticalScrollBar(ScrollBar verticalScrollBar) {
        this.verticalScrollBar.setViewport(null);
        this.remove(this.verticalScrollBar);
        this.verticalScrollBar = verticalScrollBar;
        this.add(verticalScrollBar);
        this.verticalScrollBar.setViewport(this);
        this.calculateSize();
    }

    public ScrollBar getHorizontalScrollBar() {
        return this.horizontalScrollBar;
    }

    public void setHorizontalScrollBar(ScrollBar horizontalScrollBar) {
        this.horizontalScrollBar.setViewport(null);
        this.remove(this.horizontalScrollBar);
        this.horizontalScrollBar = horizontalScrollBar;
        this.add(horizontalScrollBar);
        this.horizontalScrollBar.setViewport(this);
        this.calculateSize();
    }

    public boolean isHorizontalScrollBarVisible() {
        return this.horizontalScrollBar.getStyle().getDisplay() != Style.DisplayType.NONE;
    }

    public void setHorizontalScrollBarVisible(boolean enabled) {
        if (enabled) {
            Length<Float> height = this.horizontalScrollBar.getStyle().getHeight();
            if (height == null) {
                height = LengthType.pixel(this.horizontalScrollBar.getSize().y);
                this.horizontalScrollBar.getStyle().setHeight(height);
            }
            this.viewport.getStyle().setBottom(height);
            this.verticalScrollBar.getStyle().setBottom(height);
        } else {
            this.viewport.getStyle().setBottom(0.0f);
            this.verticalScrollBar.getStyle().setBottom(0.0f);
        }
        this.horizontalScrollBar.getStyle().setDisplay(enabled ? Style.DisplayType.MANUAL : Style.DisplayType.NONE);
        this.calculateSize();
    }

    public boolean isVerticalScrollBarVisible() {
        return this.verticalScrollBar.getStyle().getDisplay() != Style.DisplayType.NONE;
    }

    public void setVerticalScrollBarVisible(boolean enabled) {
        if (enabled) {
            Length<Float> width = this.verticalScrollBar.getStyle().getWidth();
            if (width == null) {
                width = LengthType.pixel(this.verticalScrollBar.getSize().x);
                this.verticalScrollBar.getStyle().setWidth(width);
            }
            this.viewport.getStyle().setRight(width);
            this.horizontalScrollBar.getStyle().setRight(width);
        } else {
            this.viewport.getStyle().setRight(0.0f);
            this.horizontalScrollBar.getStyle().setRight(0.0f);
        }
        this.verticalScrollBar.getStyle().setDisplay(enabled ? Style.DisplayType.MANUAL : Style.DisplayType.NONE);
        this.calculateSize();
    }

    public void setHorizontalScrollBarHeight(float height) {
        this.horizontalScrollBar.getStyle().setHeight(height);
        this.viewport.getStyle().setBottom(height);
        this.verticalScrollBar.getStyle().setBottom(height);
        this.calculateSize();
    }

    public void setVerticalScrollBarWidth(float width) {
        this.verticalScrollBar.getStyle().setWidth(width);
        this.viewport.getStyle().setRight(width);
        this.horizontalScrollBar.getStyle().setRight(width);
        this.calculateSize();
    }

    public Component getContainer() {
        return this.container;
    }

    public void setContainer(Component container) {
        this.viewport.remove(this.container);
        this.container = container;
        this.viewport.add(this.container);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScrollablePanel)) {
            return false;
        }
        ScrollablePanel panel = (ScrollablePanel)o;
        return new EqualsBuilder().appendSuper(super.equals(o)).append((Object)this.verticalScrollBar, (Object)panel.verticalScrollBar).append((Object)this.horizontalScrollBar, (Object)panel.horizontalScrollBar).append((Object)this.viewport, (Object)panel.viewport).append((Object)this.container, (Object)panel.container).isEquals();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("verticalScrollBar", (Object)this.verticalScrollBar).append("horizontalScrollBar", (Object)this.horizontalScrollBar).append("viewport", (Object)this.viewport).append("container", (Object)this.container).toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append((Object)this.verticalScrollBar).append((Object)this.horizontalScrollBar).append((Object)this.viewport).append((Object)this.container).toHashCode();
    }

    public Component getViewport() {
        return this.viewport;
    }

    @Override
    public Vector2f getViewportSize() {
        return new Vector2f((Vector2fc)this.viewport.getSize());
    }

    @Override
    public Vector2f getViewportViewSize() {
        return new Vector2f((Vector2fc)this.container.getSize());
    }

    public boolean isAutoResize() {
        return this.autoResize;
    }

    public void setAutoResize(boolean autoResize) {
        this.autoResize = autoResize;
    }

    public static class ScrollablePanelContainer
    extends Panel {
        public ScrollablePanelContainer() {
        }

        public ScrollablePanelContainer(float x, float y, float width, float height) {
            super(x, y, width, height);
        }

        public ScrollablePanelContainer(Vector2f position, Vector2f size) {
            super(position, size);
        }
    }

    public static class ScrollablePanelViewport
    extends Panel {
        public ScrollablePanelViewport() {
        }

        public ScrollablePanelViewport(float x, float y, float width, float height) {
            super(x, y, width, height);
        }

        public ScrollablePanelViewport(Vector2f position, Vector2f size) {
            super(position, size);
        }
    }
}

