/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.component;

import com.spinyowl.legui.component.RadioButton;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class RadioButtonGroup
implements Serializable {
    private static final Map<Integer, WeakReference<RadioButtonGroup>> groupsMap = new ConcurrentHashMap<Integer, WeakReference<RadioButtonGroup>>();
    private static AtomicInteger indexer = new AtomicInteger(0);
    private final int index;
    private List<RadioButton> radioButtons = new CopyOnWriteArrayList<RadioButton>();
    private RadioButton selection;

    private RadioButtonGroup(int index) {
        this.index = index;
        groupsMap.put(index, new WeakReference<RadioButtonGroup>(this));
    }

    public RadioButtonGroup() {
        this(indexer.addAndGet(1));
    }

    public static RadioButtonGroup getGroupByIndex(int index) {
        WeakReference<RadioButtonGroup> groupWeakReference = groupsMap.get(index);
        if (groupWeakReference == null) {
            return new RadioButtonGroup(index);
        }
        RadioButtonGroup radioButtonGroup = (RadioButtonGroup)groupWeakReference.get();
        if (radioButtonGroup == null) {
            groupWeakReference.clear();
            return new RadioButtonGroup(index);
        }
        return radioButtonGroup;
    }

    public int getIndex() {
        return this.index;
    }

    protected void add(RadioButton radioButton) {
        if (this.radioButtons.contains(radioButton)) {
            return;
        }
        this.radioButtons.add(radioButton);
        if (radioButton.isChecked()) {
            if (this.selection != null) {
                this.selection.setChecked(false);
            }
            this.selection = radioButton;
        }
    }

    protected void remove(RadioButton radioButton) {
        this.radioButtons.remove(radioButton);
        if (radioButton == this.selection) {
            this.selection = null;
        }
    }

    public RadioButton getSelection() {
        return this.selection;
    }

    public void clearSelection() {
        if (this.selection != null) {
            RadioButton oldSelection = this.selection;
            this.selection = null;
            oldSelection.setChecked(false);
        }
    }

    public void setSelection(RadioButton radioButton, boolean selected) {
        if (selected && radioButton != null && radioButton != this.selection) {
            RadioButton oldSelection = this.selection;
            this.selection = radioButton;
            if (oldSelection != null) {
                oldSelection.setChecked(false);
            }
            radioButton.setChecked(true);
        }
    }

    public boolean isSelected(RadioButton radioButton) {
        return radioButton == this.selection;
    }

    public List<RadioButton> getRadioButtons() {
        return new ArrayList<RadioButton>(this.radioButtons);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return new EqualsBuilder().isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).toHashCode();
    }
}

