/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.component;

import com.spinyowl.legui.component.AbstractTextComponent;
import com.spinyowl.legui.component.event.label.LabelContentChangeEvent;
import com.spinyowl.legui.component.optional.TextState;
import com.spinyowl.legui.listener.processor.EventProcessorProvider;
import com.spinyowl.legui.style.color.ColorConstants;
import com.spinyowl.legui.style.font.TextDirection;
import com.spinyowl.legui.theme.Themes;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.joml.Vector2f;

public class Label
extends AbstractTextComponent {
    public static final String DEFAULT_LABEL_TEXT = "Label";
    private TextDirection textDirection = TextDirection.HORIZONTAL;

    public Label() {
        this(DEFAULT_LABEL_TEXT);
    }

    public Label(float x, float y, float width, float height) {
        this(DEFAULT_LABEL_TEXT, x, y, width, height);
    }

    public Label(Vector2f position, Vector2f size) {
        this(DEFAULT_LABEL_TEXT, position, size);
    }

    public Label(String text) {
        this.initialize(text);
    }

    public Label(String text, float x, float y, float width, float height) {
        super(x, y, width, height);
        this.initialize(text);
    }

    public Label(String text, Vector2f position, Vector2f size) {
        super(position, size);
        this.initialize(text);
    }

    private void initialize(String text) {
        BiConsumer<String, String> callback = (oldValue, newValue) -> EventProcessorProvider.getInstance().pushEvent(new LabelContentChangeEvent(this, null, this.getFrame(), (String)oldValue, (String)newValue));
        this.textState = new TextState(text, callback);
        this.getStyle().getBackground().setColor(ColorConstants.transparent());
        this.getStyle().setBorder(null);
        Themes.getDefaultTheme().getThemeManager().getComponentTheme(Label.class).applyAll(this);
    }

    public TextDirection getTextDirection() {
        return this.textDirection;
    }

    public void setTextDirection(TextDirection textDirection) {
        this.textDirection = Objects.requireNonNull(textDirection);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Label label = (Label)o;
        return new EqualsBuilder().appendSuper(super.equals(o)).append((Object)this.textState, (Object)label.textState).append((Object)this.textDirection, (Object)label.textDirection).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append((Object)this.textState).append((Object)this.textDirection).toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("textState", (Object)this.textState).append("textDirection", (Object)this.textDirection).toString();
    }
}

