/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.component;

import com.spinyowl.legui.component.AbstractTextComponent;
import com.spinyowl.legui.component.event.checkbox.CheckBoxChangeValueEvent;
import com.spinyowl.legui.component.misc.listener.checkbox.CheckBoxMouseClickEventListener;
import com.spinyowl.legui.component.optional.TextState;
import com.spinyowl.legui.component.optional.align.HorizontalAlign;
import com.spinyowl.legui.event.MouseClickEvent;
import com.spinyowl.legui.icon.CharIcon;
import com.spinyowl.legui.icon.Icon;
import com.spinyowl.legui.listener.EventListener;
import com.spinyowl.legui.style.color.ColorConstants;
import com.spinyowl.legui.theme.Themes;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.joml.Vector2f;

public class CheckBox
extends AbstractTextComponent {
    public static final String DEFAULT_CHECK_BOX_TEXT = "CheckBox";
    private boolean checked;
    private Icon iconChecked = new CharIcon(new Vector2f(14.0f, 14.0f), "MaterialIcons-Regular", '\ue834');
    private Icon iconUnchecked = new CharIcon(new Vector2f(14.0f, 14.0f), "MaterialIcons-Regular", '\ue835');

    public CheckBox() {
        this(DEFAULT_CHECK_BOX_TEXT);
    }

    public CheckBox(float x, float y, float width, float height) {
        this(DEFAULT_CHECK_BOX_TEXT, x, y, width, height);
    }

    public CheckBox(Vector2f position, Vector2f size) {
        this(DEFAULT_CHECK_BOX_TEXT, position, size);
    }

    public CheckBox(String text) {
        this.initialize(text);
    }

    public CheckBox(String text, float x, float y, float width, float height) {
        super(x, y, width, height);
        this.initialize(text);
    }

    public CheckBox(String text, Vector2f position, Vector2f size) {
        super(position, size);
        this.initialize(text);
    }

    private void initialize(String text) {
        this.textState = new TextState(text);
        this.getStyle().getBackground().setColor(ColorConstants.transparent());
        this.getStyle().setBorder(null);
        this.getListenerMap().addListener(MouseClickEvent.class, new CheckBoxMouseClickEventListener());
        this.iconChecked.setHorizontalAlign(HorizontalAlign.LEFT);
        this.iconUnchecked.setHorizontalAlign(HorizontalAlign.LEFT);
        Themes.getDefaultTheme().getThemeManager().getComponentTheme(CheckBox.class).applyAll(this);
    }

    public Icon getIconUnchecked() {
        return this.iconUnchecked;
    }

    public void setIconUnchecked(Icon iconUnchecked) {
        if (iconUnchecked != null) {
            this.iconUnchecked = iconUnchecked;
        }
    }

    public Icon getIconChecked() {
        return this.iconChecked;
    }

    public void setIconChecked(Icon iconChecked) {
        if (iconChecked != null) {
            this.iconChecked = iconChecked;
        }
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    public void addCheckBoxChangeValueListener(EventListener<CheckBoxChangeValueEvent> listener) {
        this.getListenerMap().addListener(CheckBoxChangeValueEvent.class, listener);
    }

    public List<EventListener<CheckBoxChangeValueEvent>> getCheckBoxChangeValueEventListeners() {
        return this.getListenerMap().getListeners(CheckBoxChangeValueEvent.class);
    }

    public void removeCheckBoxChangeValueListener(EventListener<CheckBoxChangeValueEvent> listener) {
        this.getListenerMap().removeListener(CheckBoxChangeValueEvent.class, listener);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckBox checkBox = (CheckBox)o;
        return new EqualsBuilder().appendSuper(super.equals(o)).append(this.checked, checkBox.checked).append((Object)this.textState, (Object)checkBox.textState).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append((Object)this.textState).append(this.checked).toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("textState", (Object)this.textState).append("checked", this.checked).toString();
    }
}

