/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui;

import com.spinyowl.legui.component.Frame;
import com.spinyowl.legui.listener.processor.EventProcessor;
import com.spinyowl.legui.listener.processor.EventProcessorProvider;
import com.spinyowl.legui.system.context.CallbackKeeper;
import com.spinyowl.legui.system.context.Context;
import com.spinyowl.legui.system.context.DefaultCallbackKeeper;
import com.spinyowl.legui.system.handler.processor.SystemEventProcessor;
import com.spinyowl.legui.system.handler.processor.SystemEventProcessorImpl;
import com.spinyowl.legui.system.renderer.Renderer;
import com.spinyowl.legui.system.renderer.nvg.NvgRenderer;

public class DefaultInitializer {
    private long window;
    private Frame frame;
    private Context context;
    private EventProcessor eventProcessor;
    private SystemEventProcessor systemEventProcessor;
    private CallbackKeeper callbackKeeper;
    private Renderer renderer;

    public DefaultInitializer(long window, Frame frame) {
        this.frame = frame;
        this.window = window;
        this.context = new Context(window);
        this.callbackKeeper = new DefaultCallbackKeeper();
        CallbackKeeper.registerCallbacks(window, this.callbackKeeper);
        this.systemEventProcessor = new SystemEventProcessorImpl();
        SystemEventProcessor.addDefaultCallbacks(this.callbackKeeper, this.systemEventProcessor);
        this.eventProcessor = EventProcessorProvider.getInstance();
        this.renderer = new NvgRenderer();
    }

    public Context getContext() {
        return this.context;
    }

    public EventProcessor getGuiEventProcessor() {
        return this.eventProcessor;
    }

    public SystemEventProcessor getSystemEventProcessor() {
        return this.systemEventProcessor;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public CallbackKeeper getCallbackKeeper() {
        return this.callbackKeeper;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    public long getWindow() {
        return this.window;
    }
}

