/*
 * Decompiled with CFR 0.152.
 */
package com.oroarmor.quiltmappings.loom;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.loom.api.mappings.layered.MappingContext;
import net.fabricmc.loom.api.mappings.layered.MappingLayer;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.api.mappings.layered.spec.MappingsSpec;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.MappingWriter;
import net.fabricmc.mappingio.adapter.MappingDstNsReorder;
import net.fabricmc.mappingio.adapter.MappingSourceNsSwitch;
import net.fabricmc.mappingio.format.MappingFormat;
import net.fabricmc.mappingio.format.Tiny2Reader;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.util.GFileUtils;

public class QuiltMappingsOnLoomPlugin
implements Plugin<Project> {
    public void apply(Project target) {
        target.getExtensions().create("quiltmappings", QuiltMappingsOnLoomExtension.class, new Object[]{target});
        target.getRepositories().maven(repo -> {
            repo.setName("Quilt Releases");
            repo.setUrl((Object)"https://maven.quiltmc.org/repository/release");
        });
        target.getRepositories().maven(repo -> {
            repo.setName("Quilt Snapshots");
            repo.setUrl((Object)"https://maven.quiltmc.org/repository/snapshot");
        });
    }

    public static class QuiltMappingsOnLoomExtension {
        private final Project project;

        public QuiltMappingsOnLoomExtension(Project project) {
            this.project = project;
        }

        public MappingsSpec<?> mappings(final String quiltMappings, final boolean snapshot) {
            return new MappingsSpec<MappingLayer>(){

                public MappingLayer createLayer(MappingContext context) {
                    return new QuiltMappingsLayer(context, project, quiltMappings, snapshot);
                }

                public int hashCode() {
                    return Objects.hash(quiltMappings, snapshot);
                }
            };
        }
    }

    private record QuiltMappingsLayer(MappingContext context, Project project, String quiltMappings, boolean snapshot) implements MappingLayer
    {
        public void visit(MappingVisitor mappingVisitor) throws IOException {
            String minecraftVersion = this.context.minecraftProvider().minecraftVersion();
            File intermediaryToQm = this.project.file((Object)(".gradle/qm/qm_to_intermediary_" + minecraftVersion + ".tiny"));
            if (!intermediaryToQm.exists()) {
                Set quiltmappings = this.project.getConfigurations().detachedConfiguration(new Dependency[]{this.project.getDependencies().create((Object)this.quiltMappings)}).resolve();
                Set hashedFiles = this.project.getConfigurations().detachedConfiguration(new Dependency[]{this.project.getDependencies().create((Object)("org.quiltmc:hashed:" + minecraftVersion + (this.snapshot ? "-SNAPSHOT" : "")))}).resolve();
                File hashedFile = this.project.file((Object)(".gradle/qm/hashed_" + minecraftVersion + ".tiny"));
                this.downloadFile(hashedFiles, hashedFile);
                File quiltMappingsFile = this.project.file((Object)(".gradle/qm/qm_" + minecraftVersion + ".tiny"));
                this.downloadFile(quiltmappings, quiltMappingsFile);
                MemoryMappingTree mappings = new MemoryMappingTree(true);
                MemoryMappingTree qm = new MemoryMappingTree();
                try (FileReader reader = new FileReader(quiltMappingsFile);){
                    Tiny2Reader.read((Reader)reader, (MappingVisitor)qm);
                }
                MemoryMappingTree hashed = new MemoryMappingTree();
                try (FileReader reader = new FileReader(hashedFile);){
                    Tiny2Reader.read((Reader)reader, (MappingVisitor)hashed);
                }
                MemoryMappingTree tree = new MemoryMappingTree();
                MappingSourceNsSwitch sourceNsSwitch = new MappingSourceNsSwitch((MappingVisitor)tree, MappingsNamespace.OFFICIAL.toString());
                hashed.accept((MappingVisitor)sourceNsSwitch);
                tree.accept((MappingVisitor)qm);
                try (MappingWriter writer = MappingWriter.create((Writer)new FileWriter(intermediaryToQm), (MappingFormat)MappingFormat.TINY_2);){
                    mappings.accept((MappingVisitor)new MappingSourceNsSwitch((MappingVisitor)new MappingDstNsReorder((MappingVisitor)writer, new String[]{MappingsNamespace.NAMED.toString()}), MappingsNamespace.OFFICIAL.toString()));
                }
            }
            Tiny2Reader.read((Reader)new FileReader(intermediaryToQm), (MappingVisitor)mappingVisitor);
        }

        private void downloadFile(Set<File> dependency, File output) {
            if (!output.exists()) {
                GFileUtils.copyFile((File)this.project.zipTree(dependency.stream().iterator().next()).getFiles().stream().filter(file -> file.getName().endsWith("mappings.tiny")).findFirst().get(), (File)output);
            }
        }

        public MappingsNamespace getSourceNamespace() {
            return MappingsNamespace.OFFICIAL;
        }

        @Override
        public int hashCode() {
            return this.quiltMappings.hashCode();
        }
    }
}

