/*
 * MIT License
 *
 * Copyright (c) 2021 OroArmor (Eli Orona)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package com.oroarmor.multiitemlib.api;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_1802;

/**
 * A wrapper class for a set of {@link class_1792}s.
 */
public final class UniqueItemRegistry {
    /**
     * The {@link UniqueItemRegistry} for shears. Allows for use on entities and blocks.
     */
    public static final UniqueItemRegistry SHEARS = new UniqueItemRegistry(class_1802.field_8868);
    /**
     * The {@link UniqueItemRegistry} for fishing rods. Allows for the fishing bobber to work normally and correct rendering.
     */
    public static final UniqueItemRegistry FISHING_ROD = new UniqueItemRegistry(class_1802.field_8378);
    /**
     * The {@link UniqueItemRegistry} for shields. Allows for blocking and correct rendering.
     */
    public static final UniqueItemRegistry SHIELD = new UniqueItemRegistry(class_1802.field_8255);
    /**
     * The {@link UniqueItemRegistry} for bows. Allows for shooting arrows and correct rendering.
     */
    public static final UniqueItemRegistry BOW = new UniqueItemRegistry(class_1802.field_8102);
    /**
     * The {@link UniqueItemRegistry} for crossbows. Allows for shooting arrows and correct rendering.
     */
    public static final UniqueItemRegistry CROSSBOW = new UniqueItemRegistry(class_1802.field_8399);
    /**
     * The {@link UniqueItemRegistry} for tridents. Allows for some correct rendering. Mixins will be needed for full correct rendering.
     */
    public static final UniqueItemRegistry TRIDENT = new UniqueItemRegistry(class_1802.field_8547);

    private final Set<class_1792> itemList;

    private final class_1792 defaultItem;

    private UniqueItemRegistry(class_1792 defaultItem) {
        this.defaultItem = defaultItem;
        itemList = new HashSet<>();
    }

    public void addItemToRegistry(class_1792 item) {
        itemList.add(item);
    }

    public class_1792 getDefaultItem(class_1792 item) {
        if (isItemInRegistry(item)) {
            return defaultItem;
        }
        return item;
    }

    public boolean isItemInRegistry(class_1792 item) {
        return itemList.contains(item);
    }
}
